﻿Public Class Form1

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        txtJoinChar.Text = ","
        UpdateOutput()
    End Sub

    Private Sub AnyInputChanged(sender As Object, e As EventArgs) _
        Handles txtInput.TextChanged, txtJoinChar.TextChanged,
                chkIgnoreEmpty.CheckedChanged, chkTrimEnds.CheckedChanged
        UpdateOutput()
    End Sub

    Private Sub UpdateOutput()
        Dim lines = txtInput.Lines
        Dim joinChar As String = txtJoinChar.Text

        Dim result As New List(Of String)

        For Each line In lines
            Dim currentLine As String = line

            If chkTrimEnds.Checked Then
                currentLine = currentLine.TrimEnd(" "c, vbTab)
            End If

            If chkIgnoreEmpty.Checked AndAlso String.IsNullOrWhiteSpace(currentLine) Then
                Continue For
            End If

            result.Add(currentLine)
        Next

        txtOutput.Text = String.Join(joinChar, result)
    End Sub

End Class
